package calendrier.maree.presentation.ui


import android.content.Context
import android.graphics.Canvas
import android.graphics.Color
import android.graphics.LinearGradient
import android.graphics.Paint
import android.graphics.Path
import android.graphics.Rect
import android.graphics.Shader
import android.util.AttributeSet
import android.view.View
import calendrier.maree.data.MareeTable
import calendrier.maree.presentation.util.getCurrentDt
import java.util.Calendar
import kotlin.math.cos
import kotlin.math.min
import kotlin.math.sin

class Clock : View {
    private val paint = Paint(Paint.ANTI_ALIAS_FLAG)
    private var isRunning = false

    private var centerX = 0f
    private var centerY = 0f
    private var radius = 0f
    private var vMaree: MareeTable? = null

    fun SetMareeTable(mMareeTable: MareeTable?) {
        vMaree = mMareeTable
    }


    constructor(context: Context?) : super(context)

    constructor(context: Context?, attrs: AttributeSet?) : super(context, attrs)

    override fun onSizeChanged(width: Int, height: Int, oldw: Int, oldh: Int) {
        super.onSizeChanged(width, height, oldw, oldh)

        centerX = (width / 2).toFloat()
        centerY = (height / 2).toFloat()
        radius = min((width * 0.5f).toDouble(), (height * 0.5f).toDouble()).toFloat()
    }

    fun onResume() {
        isRunning = true
        object : Thread() {
            override fun run() {
                while (isRunning) {
                    try {
                        sleep(990)
                    } catch (e: InterruptedException) {
                        e.printStackTrace()
                    }
                    postInvalidate()
                }
            }
        }.start()
    }

    fun onPause() {
        isRunning = false
    }

    override fun onDraw(canvas: Canvas) {
        // --- Outer disk ---

        var linearGradient = LinearGradient(
            0f, centerY - radius, 0f, centerY + radius,
            intArrayOf(-0x1f1f20, -0x91888c, -0xf5f1f6, -0xf5f7f7),
            floatArrayOf(0f, 0.49f, 0.50f, 1f),
            Shader.TileMode.REPEAT
        )
        paint.setShader(linearGradient)
        canvas.drawCircle(centerX, centerY, radius, paint)

        paint.setShader(null)
        paint.color = -0xdededf
        canvas.drawCircle(centerX, centerY, radius * 0.95f, paint)

        // --- Graduations ---
        paint.color = -0x1
        paint.strokeWidth = 3f
        paint.textSize = radius / 8f

        var hour = 12
        var angle = 0f
        var vMareeH : Float =0F
        var vMareeB  : Float = 0F
        if (vMaree != null) {
            vMareeH = vMaree!!.GetMareeHFloat()
            vMareeB = vMaree!!.GetMareeBFloat()
        }


        while (angle <= 360) {
            val radianAngle = -(Math.PI / 2 - (2 * Math.PI * angle / 360)).toFloat()
            if (angle % 30 != 0f) {
                canvas.drawLine(
                    (centerX + cos(radianAngle.toDouble()) * radius * 0.85).toFloat(),
                    (centerY + sin(radianAngle.toDouble()) * radius * 0.85).toFloat(),
                    (centerX + cos(radianAngle.toDouble()) * radius * 0.90).toFloat(),
                    (centerY + sin(radianAngle.toDouble()) * radius * 0.90).toFloat(),
                    paint
                )
            } else {
                val path = Path()
                path.moveTo(
                    (centerX + cos(radianAngle - 0.01) * radius * 0.80).toFloat(),
                    (centerY + sin(radianAngle - 0.01) * radius * 0.80).toFloat()
                )
                path.lineTo(
                    (centerX + cos(radianAngle - 0.02) * radius * 0.90).toFloat(),
                    (centerY + sin(radianAngle - 0.02) * radius * 0.90).toFloat()
                )
                path.lineTo(
                    (centerX + cos(radianAngle + 0.02) * radius * 0.90).toFloat(),
                    (centerY + sin(radianAngle + 0.02) * radius * 0.90).toFloat()
                )
                path.lineTo(
                    (centerX + cos(radianAngle + 0.01) * radius * 0.80).toFloat(),
                    (centerY + sin(radianAngle + 0.01) * radius * 0.80).toFloat()
                )
                path.lineTo(
                    (centerX + cos(radianAngle - 0.01) * radius * 0.80).toFloat(),
                    (centerY + sin(radianAngle - 0.01) * radius * 0.80).toFloat()
                )
                canvas.drawPath(path, paint)

                if (hour == 12) {
                    var strHour = "≈ HAUTE"
                    val textBounds = Rect()
                    paint.getTextBounds(strHour, 0, strHour.length, textBounds)
                    paint.setColor( Color.CYAN)
                    canvas.drawText(
                        strHour,
                        (centerX + cos(radianAngle.toDouble()) * radius * 0.70 - textBounds.width() / 2).toFloat(),
                        (centerY + sin(radianAngle.toDouble()) * radius * 0.70 + textBounds.height() / 3).toFloat(),
                        paint
                    )
                    if (vMaree != null) {
                        strHour = vMaree!!.GetMareeH()
                        paint.getTextBounds(strHour, 0, strHour.length, textBounds)
                        canvas.drawText(
                            strHour,
                            (centerX + cos(radianAngle.toDouble()) * radius * 0.70 - textBounds.width() / 2).toFloat(),
                            (centerY + sin(radianAngle.toDouble()) * radius * 0.70 + textBounds.height() * 2).toFloat(),
                            paint
                        )
                    }
                    paint.setColor( Color.WHITE)

                } else if (hour == 6) {
                    var strHour = "≈ BASSE"
                    val textBounds = Rect()
                    paint.getTextBounds(strHour, 0, strHour.length, textBounds)
                    paint.setColor( Color.CYAN)
                    canvas.drawText(
                        strHour,
                        (centerX + cos(radianAngle.toDouble()) * radius * 0.70 - textBounds.width() / 2).toFloat(),
                        (centerY + sin(radianAngle.toDouble()) * radius * 0.70 - textBounds.height()).toFloat(),
                        paint
                    )
                    if (vMaree != null) {
                        strHour = vMaree!!.GetMareeB()
                        paint.getTextBounds(strHour, 0, strHour.length, textBounds)
                        canvas.drawText(
                            strHour,
                            (centerX + cos(radianAngle.toDouble()) * radius * 0.70 - textBounds.width() / 2).toFloat(),
                            (centerY + sin(radianAngle.toDouble()) * radius * 0.70 + textBounds.height() / 2).toFloat(),
                            paint
                        )
                        strHour =(vMaree!!.GetPortName()).split("-")[0]
                        paint.getTextBounds(strHour, 0, strHour.length, textBounds)
                        paint.setColor(Color.MAGENTA)
                        canvas.drawText(
                            strHour,
                            (centerX + cos(radianAngle.toDouble()) * radius * 0.70 - textBounds.width() / 2).toFloat(),
                            (centerY + sin(radianAngle.toDouble()) * radius * 0.70 - textBounds.height() * 2.5).toFloat(),
                            paint
                        )
                        strHour = getCurrentDt()
                        paint.getTextBounds(strHour, 0, strHour.length, textBounds)
                        canvas.drawText(
                            strHour,
                            (centerX + cos(radianAngle.toDouble()) * radius * 0.70 - textBounds.width() / 2).toFloat(),
                            (centerY + sin(radianAngle.toDouble()) * radius * 0.70 - textBounds.height() * 4).toFloat(),
                            paint
                        )
                        paint.setColor(Color.WHITE)
                    }
                } else if (hour > 0 && hour < 6) {
                    val strHour = "" + (6 - hour)
                    val textBounds = Rect()
                    paint.getTextBounds(strHour, 0, strHour.length, textBounds)
                    canvas.drawText(
                        strHour,
                        (centerX + cos(radianAngle.toDouble()) * radius * 0.70 - textBounds.width() / 2).toFloat(),
                        (centerY + sin(radianAngle.toDouble()) * radius * 0.70 + textBounds.height() / 3).toFloat(),
                        paint
                    )
                } else if (hour > 6 && hour < 12) {
                    val strHour = "" + (12 - hour)
                    val textBounds = Rect()
                    paint.getTextBounds(strHour, 0, strHour.length, textBounds)
                    canvas.drawText(
                        strHour,
                        (centerX + cos(radianAngle.toDouble()) * radius * 0.70 - textBounds.width() / 2).toFloat(),
                        (centerY + sin(radianAngle.toDouble()) * radius * 0.70 + textBounds.height() / 3).toFloat(),
                        paint
                    )
                }
                hour = ++hour % 12
            }

            angle += 6f
        }

        // --- Clockwise ---
        var now :Calendar = Calendar.getInstance()

        // timer maree
        //var vCurrenTime = (now.get(Calendar.HOUR_OF_DAY)+1 + now.get(Calendar.MINUTE) / 60f)
        var vCurrenTime = (now.get(Calendar.HOUR_OF_DAY) + now.get(Calendar.MINUTE) / 60f)
        if (vMaree != null) {
            // Maree basse
               angle = 90F
                var radianAngle = -(Math.PI / 2 - (2 * Math.PI * angle / 360)).toFloat()
                var strHour =""
                if (vMareeB < vCurrenTime) {
                    strHour = "▼" + FormatTimeValue(vMareeB + 24 - vCurrenTime)
                }
                else {
                    strHour = "▼" + FormatTimeValue(vMareeB  - vCurrenTime)
                }
                var textBounds = Rect()
                paint.getTextBounds(strHour, 0, strHour.length, textBounds)
                paint.setColor(Color.MAGENTA)
                canvas.drawText(
                    strHour,
                    (centerX + cos(radianAngle.toDouble()) * radius * 0.40 - textBounds.width()/2 ).toFloat(),
                    (centerY + sin(radianAngle.toDouble()) * radius * 0.70 + textBounds.height() / 3).toFloat(),
                    paint
                )

            // Maree haute
            angle = 270F

            radianAngle = -(Math.PI / 2 - (2 * Math.PI * angle / 360)).toFloat()
            if (vMareeH < vCurrenTime){
                strHour = "▲" + FormatTimeValue(vMareeH+24F - vCurrenTime.toFloat())
            }
            else {
                strHour = "▲" + FormatTimeValue(vMareeH - vCurrenTime.toFloat())
            }

            textBounds = Rect()
            paint.getTextBounds(strHour, 0, strHour.length, textBounds)

            canvas.drawText(
                strHour,
                (centerX + cos(radianAngle.toDouble()) * radius * 0.40 - textBounds.width()/2 ).toFloat(),
                (centerY + sin(radianAngle.toDouble()) * radius * 0.70 + textBounds.height() / 3).toFloat(),
                paint
            )
            // Current Time
            angle = 0F
            vCurrenTime = (now.get(Calendar.HOUR_OF_DAY) + now.get(Calendar.MINUTE) / 60f)
            radianAngle = -(Math.PI / 2 - (2 * Math.PI * angle / 360)).toFloat()
            strHour = "" + FormatTimeValue(vCurrenTime.toFloat() )
            textBounds = Rect()
            paint.getTextBounds(strHour, 0, strHour.length, textBounds)
            paint.textSize = textBounds.width()/1.5F

            canvas.drawText(
                strHour,
                (centerX + cos(radianAngle.toDouble()) * radius * 0.70- textBounds.width() / 1.3 ).toFloat(),
                (centerY + sin(radianAngle.toDouble()) * radius * 0.70 + textBounds.height() * 4.5).toFloat(),
                paint
            )
            paint.setColor(Color.WHITE)

        }
        var vGap = 12-(vMareeH - (now[Calendar.HOUR]+1 % 12 + now[Calendar.MINUTE] / 60f))
        var hourAngle = (((Math.PI * 2).toFloat()) * (ToHeure(vGap) % 12 + (ToMinute(vGap))/ 60f) / 12f)
        //var hourAngle = (((Math.PI * 2).toFloat()) * (now[Calendar.HOUR]+1 % 12 + (now[Calendar.MINUTE])/ 60f) / 12f)
        hourAngle -= Math.PI.toFloat() / 2

        paint.color = -0x66000100

        val path = Path()
        path.moveTo(
            (centerX + cos(hourAngle.toDouble()) * radius * 0.60).toFloat(),
            (centerY + sin(hourAngle.toDouble()) * radius * 0.60).toFloat()
        )
        path.lineTo(
            (centerX + cos(hourAngle - 0.4) * radius * 0.10).toFloat(),
            (centerY + sin(hourAngle - 0.4) * radius * 0.10).toFloat()
        )
        path.lineTo(
            (centerX + cos(hourAngle + 0.4) * radius * 0.10).toFloat(),
            (centerY + sin(hourAngle + 0.4) * radius * 0.10).toFloat()
        )
        path.lineTo(
            (centerX + cos(hourAngle.toDouble()) * radius * 0.60).toFloat(),
            (centerY + sin(hourAngle.toDouble()) * radius * 0.60).toFloat()
        )
        canvas.drawPath(path, paint)

        paint.color = -0x10000
        canvas.drawLine(
            (centerX + cos(hourAngle.toDouble()) * radius * 0.60).toFloat(),
            (centerY + sin(hourAngle.toDouble()) * radius * 0.60).toFloat(),
            (centerX + cos(hourAngle - 0.4) * radius * 0.10).toFloat(),
            (centerY + sin(hourAngle - 0.4) * radius * 0.10).toFloat(),
            paint
        )
        canvas.drawLine(
            (centerX + cos(hourAngle.toDouble()) * radius * 0.60).toFloat(),
            (centerY + sin(hourAngle.toDouble()) * radius * 0.60).toFloat(),
            (centerX + cos(hourAngle + 0.4) * radius * 0.10).toFloat(),
            (centerY + sin(hourAngle + 0.4) * radius * 0.10).toFloat(),
            paint
        )

        paint.color = -0x66010000
        paint.strokeWidth = 8f
        var secondAngle = ((Math.PI * 2).toFloat()) * now[Calendar.SECOND] / 60f
        secondAngle -= Math.PI.toFloat() / 2

        canvas.drawLine(
            (centerX + cos(secondAngle.toDouble()) * radius * 0.94).toFloat(),
            (centerY + sin(secondAngle.toDouble()) * radius * 0.94).toFloat(),
            (centerX + cos(secondAngle.toDouble()) * radius * 0.10).toFloat(),
            (centerY + sin(secondAngle.toDouble()) * radius * 0.10).toFloat(),
            paint
        )

        // --- Inner disk ---
        paint.color = -0x1000000

        linearGradient = LinearGradient(
            0f, centerY - radius * 0.2f, 0f, centerY + radius * 0.2f,
            intArrayOf(-0x1f1f20, -0x91888c, -0xf5f1f6, -0xf5f7f7),
            floatArrayOf(0f, 0.49f, 0.50f, 1f),
            Shader.TileMode.REPEAT
        )
        paint.setShader(linearGradient)
        canvas.drawCircle(centerX, centerY, radius * 0.18f, paint)

        paint.setShader(null)
        paint.color = -0xdededf
        canvas.drawCircle(centerX, centerY, radius * 0.15f, paint)
    }
}

fun ToMinute(vTime: Float) : Int {

        return ((vTime - vTime.toInt())*100F).toInt()
}

fun ToHeure(vTime : Float) : Int {
    return vTime.toInt()
}
fun FormatTimeValue(vTime : Float) : String {
    val vMString = ((vTime - vTime.toInt())*60F).toInt().toString()
    return vTime.toInt().toString()+":"+("0$vMString").substring(vMString.length-1,vMString.length+1)
}