package calendrier.maree.data

import java.time.LocalDate
import java.time.LocalDateTime
import java.time.LocalTime
import java.time.format.DateTimeFormatter
import java.time.temporal.ChronoUnit
import java.util.Calendar
import kotlin.math.atan2
import kotlin.math.cos
import kotlin.math.pow
import kotlin.math.sin
import kotlin.math.sqrt

// classe contenant les données de la carte des marées

class MareeTable {

    private lateinit var vDateMaree: String

    private val vMareeHaute = arrayOf("", "", "")
    val globalportList : MutableList<PortsMaree> = ArrayList()

    var vMareeObj: MutableList<BddMareeTable> = ArrayList()
    var vDatesMaree : MutableList<WatchModelDt> = ArrayList()
    var vCurrentDateMaree : LocalDate=LocalDate.now()
    var vMareeDateIndex : Int = 0
    var vLocalDt : LocalDate=LocalDate.parse("2024-01-01", DateTimeFormatter.ISO_DATE)
    var vLocalTm : LocalTime = LocalTime.now().plusHours(1).truncatedTo(ChronoUnit.MINUTES)
    var vMareeH : Boolean = false
    var vHauteur : Float = 0F
    var vCoeef : Int = 0
    var mScreenSizes : Float = 200f
    var mCoeefSize : Float = 1f
    var vCurrentTimeToSet = LocalDateTime.now().toLocalTime().plusHours(2)

    // var vDataMaree = BddMareeTable(LocalDate(2024,9,19),true, LocalTime(0,0,0,0),0.0 ,0)


    private var TableMaree = arrayOf<BddMareeTable>(/* no-op */)



    private var TableauPortMaree = arrayOf<PortsMaree>(/* no-op */)
    private var vPos1 = 0
    private var vPos2 = 0
    private var vPosRet = 0
    private var vIndex = 0
    private var vStopRead = false
    private var vPortId: String ="LA_ROCHELLE-PALLICE"

    fun timeToString(vTime : Float) : String{

        val vRet  = if (vTime<=180) (6f/180f)*(180-vTime) else  (6f/180f)*(360-vTime)
        val vH =(vRet).toInt()
        val vM = ((vRet-vH)*60f).toInt()
        val vMString = vM.toString()
        return "$vH"+":"+("0$vMString").substring(vMString.length-1,vMString.length+1)
    }

    fun GetShomUrl() : String{
        //val vRet = "https://services.data.shom.fr/hdm/vignette/petite/"+GetPortName()+"?locale=fr" //date="+vCurrentDateMaree.toString()+"&utc=standard"
        val vRet = "https://services.data.shom.fr/hdm/vignette/grande/"+GetPortName()+"?locale=fr" //date="+vCurrentDateMaree.toString()+"&utc=standard"

        return vRet
    }

    fun GetShomUrlCoordonnee() : String{
       val vRet = "https://maree.shom.fr/harbor/"+GetPortName()+"/hlt/0?date=2025-08-06&utc=standard"

        return vRet
    }

    fun LoadMareeTable(vText: String) {
        vMareeObj.clear()
        vStopRead=false
        vIndex=0
        vPosRet = readThead(vText, 0,"<!--thead>")
        if (vPosRet > 0) {
            vPosRet = vText.indexOf("<tbody>", vPosRet)
            while ( !vStopRead  && vPosRet> 0)
            {
                vPosRet = readBody(vText, vPosRet)
                if (vPosRet > 0 ) {
                    if (vHauteur != 0f && GetMareeOK()) {
                        vMareeObj.add(
                            vIndex,
                            BddMareeTable(vLocalDt, vMareeH, vLocalTm, vHauteur, vCoeef)
                        )
                        vIndex++
                    }
                    vPos1 = vPosRet
                    if (nextMaree(vText, vPos1)) {
                        vPosRet = readThead(vText, vPos1,"<thead>")
                    }
                }
                else {vStopRead = true}
            }

        }

    }


fun GetMareeOK() : Boolean{

    return true

//    val cal :Calendar = Calendar.getInstance() // creates calendar
//    var vHourRef : Int =0
//    if (vMareeH)  vHourRef = cal.get(Calendar.HOUR_OF_DAY)+1 else vHourRef = cal.get(Calendar.HOUR_OF_DAY)+7
//
//    val vLocalTm = vLocalTm.hour
//    if (vHourRef > vLocalTm)
//    {  return false
//    }
//    return true
}
    fun LoadDatesMaree(){

        vDatesMaree.clear()
        var vDtString=""
        var vValIndex=""
        var vTabMaree=""
        var vIndex=0
        for (vValue in vMareeObj)
        {   vValIndex=vValue.getdate().toString()

            if ((vDtString != vValIndex || vValue.getmarreHaute())&& vDtString != "")
            {   vDatesMaree.add(vIndex, WatchModelDt(vIndex, vDtString, vTabMaree))
                vIndex++
                //vTabMaree= if (vValue.getmarreHaute()) "PM : " + vValue.getheure().toString() + " - Coef : " + vValue.getcoeff().toString() else "BM : " + vValue.getheure().toString() + " Coef : " + vValue.getcoeff().toString()
                vTabMaree = formatTableMaree(vValue.getmarreHaute(),vValue.getheure(),vValue.gethauteur(),vValue.getcoeff())
            }
            else {
                if (vTabMaree=="") {
                    vTabMaree = formatTableMaree(vValue.getmarreHaute(),vValue.getheure(),vValue.gethauteur(),vValue.getcoeff())
                    //vTabMaree= if (vValue.getmarreHaute()) "PM : " + vValue.getheure().toString() + " Coef : " + vValue.getcoeff().toString() else "BM : " + vValue.getheure().toString()+ " Coef : " + vValue.getcoeff().toString()
                } else{
                    //vTabMaree = vTabMaree + "\n" + if (vValue.getmarreHaute()) "PM : " + vValue.getheure().toString() + " Coef : " + vValue.getcoeff().toString() else "BM : " +vValue.getheure().toString() + " Coef : " + vValue.getcoeff().toString()
                    vTabMaree = vTabMaree + "\n" + formatTableMaree(vValue.getmarreHaute(),vValue.getheure(),vValue.gethauteur(),vValue.getcoeff())
                }
            }
            vDtString = vValIndex
        }
    }

        private fun formatTableMaree (vMareeTime : Boolean, vHeure : LocalTime, vHauteur : Float, vCoeef : Int) : String{
            var vRet=""

             if (vMareeTime){
                 vRet = "PM : " + vHeure.toString().replace(":","h") + " H:" + vHauteur.toString()+"m"+ " C:" + vCoeef.toString()
             }
            else {
                 vRet = "BM : " + vHeure.toString().replace(":","h")+ " H:" + vHauteur.toString()+"m"
             }

            return vRet
        }
    private fun readThead(vText: String, vPos: Int,vThead : String): Int {
        val vPosG = vText.indexOf(vThead, vPos)
        if ( vPosG > 0 ) {
            val vPosD = vText.indexOf("</th>", vPosG)
            if (vPosD > 11) {
                vDateMaree = vText.substring(vPosD - 10, vPosD)
                vLocalDt = LocalDate.parse(vDateMaree, DateTimeFormatter.ofPattern("dd/MM/yyyy"))
                return vPosD
            }
        }
        return 0
    }

    private fun readBody(vText: String, vPos: Int): Int {

        var vPosD = vText.indexOf("</tr>", vPos)
        if (vPosD > 5) {
            vPosD = readTD( vText, vPosD, 1)+60
            if (vPosD > 70) {
                vPosD = readTD(vText, vPosD, 2) + 5
                vPosD = readTD(vText, vPosD, 3) + 4
                vPosD = readTD(vText, vPosD, 4) + 3
            }
            else {vPosD = 0}
        }
        return vPosD
    }

    private fun nextMaree(vText : String,vPos : Int) : Boolean{
        var vPosD = vText.indexOf("<thead>", vPos)
        var vPosG = vText.indexOf("</td>", vPos)
        var vRet: Boolean = (vPosG > vPosD && vPosD > 0 && vPosG > 0)
        return (vRet)
    }
    private fun readTD(vText: String, vPos: Int, vTypeData: Int): Int {
        var vValtxt = ""
        val vPosD = vText.indexOf("</td>", vPos)
        if (vPosD > 0) {
            when (vTypeData) {
                // Type 1 : PM ou BM
                1 -> {
                    vValtxt = vText.substringSafe(vPosD - 56, vPosD - 54)
                    vMareeH = vValtxt == "PM"
                }
                // Type 2 : Heure
                2 -> {
                    vValtxt = vText.substringSafe(vPosD - 5, vPosD)
                    if (vValtxt == "--:--" || vValtxt.getOrNull(2) != ':') {
                        vLocalTm = LocalTime.parse("00:00", DateTimeFormatter.ofPattern("HH:mm"))
                    } else {
                        runCatching {
                            vLocalTm = LocalTime.parse(vValtxt, DateTimeFormatter.ofPattern("HH:mm"))
                        }.onFailure {
                            vLocalTm = LocalTime.parse("00:00", DateTimeFormatter.ofPattern("HH:mm"))
                        }
                    }
                }
                // Type 3 : Hauteur
                3 -> {
                    vValtxt = vText.substringSafe(vPosD - 4, vPosD)
                    vHauteur = vValtxt
                        .replace(",", ".")
                        .toFloatOrNull() ?: 0f
                }
                // Type 4 : Coefficient
                4 -> {
                    vValtxt = vText.substringSafe(vPosD - 3, vPosD)
                    vCoeef = when {
                        vValtxt == "---" -> 0
                        vText.substringSafe(vPosD - 3, vPosD - 2) == ">" ->
                            vText.substringSafe(vPosD - 2, vPosD).toIntOrNull() ?: 0
                        else -> vValtxt.toIntOrNull() ?: 0
                    }
                }
            }
        }
        return vPosD
    }

    /**
     * Extension pour éviter les IndexOutOfBounds sur substring
     */
    private fun String.substringSafe(start: Int, end: Int): String {
        val safeStart = start.coerceAtLeast(0).coerceAtMost(length)
        val safeEnd = end.coerceAtLeast(safeStart).coerceAtMost(length)
        return substring(safeStart, safeEnd).trim()
    }

    fun SectorRight() : Boolean {
        return (GetMareeTime() < 180f)
    }

    fun GetMareeValue(vIndex: Int): BddMareeTable {
        return vMareeObj[vIndex]
    }


    fun GetMareeH (): String{
        return GetMareeValue(GetIndexMareeDatePM()).getheure().toString()
    }
    fun GetMareeB (): String{
        return GetMareeValue(GetIndexMareeDateBM()).getheure().toString()
    }
    fun GetMareeHFloat (): Float{
        return (GetMareeValue(GetIndexMareeDatePM()).getheure().hour+GetMareeValue(GetIndexMareeDatePM()).getheure().minute/60f)
    }
    fun GetMareeBFloat (): Float{
        return (GetMareeValue(GetIndexMareeDateBM()).getheure().hour+GetMareeValue(GetIndexMareeDateBM()).getheure().minute/60f)
    }

    fun GetAddHour() : Float{
        val startDate = GetMareeValue(0).getdate()
        val endDate = LocalDate.now()

        val diff: Int = startDate.dayOfMonth-  endDate.dayOfMonth
        return (if (diff == 0) 0f else 24f)
    }

    fun GetMareeTime():Float{
        var vRet=90f
        val vCurrentTime = vCurrentTimeToSet //LocalDateTime.now().toLocalTime()

        val vMareeB = GetMareeBFloat()
        val vMareeH = GetMareeHFloat()
        val vHour = (vCurrentTime.hour+ vCurrentTime.minute/60f) + GetAddHour()
        if(vMareeB > vHour) {
            vRet = (6-(vMareeB - vHour))*30f
        }
        else {
            if (vMareeH>vHour) {
                vRet = (12 - (vMareeH - vHour)) * 30f
            }
            else {
                vRet = (12 - (vMareeH+24 - vHour)) * 30f
            }
        }
        return vRet
    }

    fun currentIndexPortName() : Int {
        var vIndex = 1
        val vName = vPortId
        for (vValue in WatchLocalDataSource().portsCoteOuest)
        {   if (vValue.portId == vName)
        {   return vIndex
        }
            vIndex++
        }
        return 1
    }

    fun haversine (lat1: Double, lon1 : Double, lat2: Double, lon2: Double) : Double {
        val R = 6371.0 // Rayon de la Terre en km
        val dLat = Math.toRadians(lat2 - lat1)
        val dLon = Math.toRadians(lon2 - lon1)
        val a = sin(dLat / 2).pow(2.0) + cos(Math.toRadians(lat1)) *
                cos(Math.toRadians(lat2)) * sin(dLon / 2).pow(2.0)
        val c = 2 * atan2(sqrt(a), sqrt(1 - a))
        return R * c
    }
    fun findNearestPortIndex(
        userLat: Double,
        userLon: Double,
        ports: List<PortsMaree>
    ): Int? {
        return ports.minByOrNull { port ->
            haversine(userLat, userLon, port.latitude, port.longitude)
        }?.portIndex
    }
    fun findNearestPortId(
        userLat: Double,
        userLon: Double,
        ports: List<PortsMaree>
    ): String? {
        return ports.minByOrNull { port ->
            haversine(userLat, userLon, port.latitude, port.longitude)
        }?.portId
    }

    fun GetIndexMyPort(userLat: Double, userLon: Double)  {
        val dataSource = WatchLocalDataSource()

        vPortId = findNearestPortId(userLat, userLon, dataSource.portsCoteOuest).toString()

    }

    fun isPortSelected(vPortValue : String) : Boolean{
        return vPortValue == vPortId
    }

    fun SetIndexPortName(vIndex : Int)  {
        for (vValue in WatchLocalDataSource().portsCoteOuest)
        {   if (vValue.portIndex == vIndex)
            {   vPortId = vValue.portId
                break
            }
        }
    }

    fun SetIndexMareeDate(vIndex : Int)  {
        vMareeDateIndex = vIndex
    }

    fun GetIndexMareeDatePM() :Int {
        if (vDatesMaree.isEmpty()) {
        }
        else{
            var vDateIndex: String = vDatesMaree[vMareeDateIndex].dtString
            var vCount = 0
            val cal: Calendar = Calendar.getInstance() // creates calendar
            var vHourRef = cal.get(Calendar.HOUR_OF_DAY) + 2

            for (vValue in vMareeObj) {
                if (vValue.getmarreHaute()) {
                    if (vValue.getdate().toString() == vDateIndex) {
                        if ((vValue.getheure().hour > vHourRef))
                            return vCount
                    } else if (vValue.getdate().toString() > vDateIndex) {
                        if ((vValue.getheure().hour + 24 > vHourRef))
                            return vCount
                    }
                }
                vCount++
            }
        }
        return 0
    }
    fun GetIndexMareeDateBM() :Int {
        var vDateIndex : String = vDatesMaree[vMareeDateIndex].dtString
        var vCount = 0
        val cal :Calendar = Calendar.getInstance() // creates calendar
        var vHourRef = cal.get(Calendar.HOUR_OF_DAY)+2

        for(vValue in vMareeObj )
        {   if (!vValue.getmarreHaute()) {
            if (vValue.getdate().toString() == vDateIndex) {
                if ((vValue.getheure().hour > vHourRef))
                    return vCount
            }
            else if (vValue.getdate().toString() > vDateIndex) {
                if ((vValue.getheure().hour+24 > vHourRef))
                    return vCount
            }
        }
            vCount++
        }
        return 0
    }

    fun GetPortName() : String {
        return vPortId
    }
    fun SetPortName( vPort : String){
        vPortId = vPort
    }
    fun GetPortId(vIndex : Int) : String {
        for (vValue in WatchLocalDataSource().portsCoteOuest)
        {   if (vValue.portIndex == vIndex) {
            vPortId = vValue.portId
            break
        }
        }
        return vPortId
    }
}
