/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package calendrier.maree.data

/**
 * Liste des ports de la cote ouest de la France avec les coordonées GPS.
 */


class WatchLocalDataSource {
    val portsCoteOuest = listOf(
        PortsMaree(
            portIndex = 0,
            portId = "ABER_BENOIT_MEAN_RENEAT",
            portName = "L'Aber Benoît",
            latitude = 48.5915,
            longitude = -4.63333
        ),
        PortsMaree(
            portIndex = 1,
            portId = "ABER_WRAC_H",
            portName = "L'Aber Wrac'h",
            latitude = 48.59833,
            longitude = -4.56167
        ),
        PortsMaree(
            portIndex = 2,
            portId = "AIGUILLON_SUR_MER",
            portName = "L'Aiguillon-sur-Mer",
            latitude = 46.335,
            longitude = -1.31639
        ),
        PortsMaree(
            portIndex = 4,
            portId = "ALPHA-BAIE_DE_SEINE",
            portName = "Alpha-Baie de Seine",
            latitude = 49.85972,
            longitude = -0.38867
        ),
        PortsMaree(
            portIndex = 5,
            portId = "ANTIFER",
            portName = "Le Havre-Antifer (Terminal pétrolier)",
            latitude = 49.65,
            longitude = 0.15
        ),
        PortsMaree(
            portIndex = 6,
            portId = "ARCACHON_EYRAC",
            portName = "Arcachon",
            latitude = 44.66433,
            longitude = -1.16367
        ),
        PortsMaree(
            portIndex = 7,
            portId = "ARRADON",
            portName = "Arradon",
            latitude = 47.615,
            longitude = -2.83
        ),
        PortsMaree(
            portIndex = 8,
            portId = "ARROMANCHES-LES-BAINS",
            portName = "Arromanches-les-Bains",
            latitude = 49.3555,
            longitude = -0.62
        ),
        PortsMaree(
            portIndex = 9,
            portId = "AUDIERNE",
            portName = "Audierne (Quai Pelletan)",
            latitude = 48.02156,
            longitude = -4.53758
        ),
        PortsMaree(
            portIndex = 10,
            portId = "AURAY_SAINT-GOUSTAN",
            portName = "Auray (St-Goustan)",
            latitude = 47.66339,
            longitude = -2.97811
        ),
        PortsMaree(
            portIndex = 11,
            portId = "BAIE_DU_STIFF",
            portName = "Baie du Stiff (Île d'Ouessant)",
            latitude = 48.46803,
            longitude = -5.05406
        ),
        PortsMaree(
            portIndex = 12,
            portId = "BALISE_A",
            portName = "PK 364,775 : Balise A",
            latitude = 49.43333,
            longitude = 0.12167
        ),
        PortsMaree(
            portIndex = 14,
            portId = "BARFLEUR",
            portName = "Barfleur",
            latitude = 49.66667,
            longitude = -1.25
        ),
        PortsMaree(
            portIndex = 16,
            portId = "BENODET",
            portName = "Bénodet",
            latitude = 47.881,
            longitude = -4.11583
        ),
        PortsMaree(
            portIndex = 17,
            portId = "BINIC",
            portName = "Binic",
            latitude = 48.6,
            longitude = -2.81667
        ),
        PortsMaree(
            portIndex = 18,
            portId = "BISCARROSSE",
            portName = "Biscarrosse",
            latitude = 44.46756,
            longitude = -1.27075
        ),
        PortsMaree(
            portIndex = 20,
            portId = "BORDEAUX",
            portName = "Bordeaux",
            latitude = 44.85997,
            longitude = -0.55281
        ),
        PortsMaree(
            portIndex = 21,
            portId = "BOUCAU-BAYONNE",
            portName = "Boucau-Bayonne",
            latitude = 43.52722,
            longitude = -1.51472
        ),
        PortsMaree(
            portIndex = 22,
            portId = "BOUEE_FORT-MAHON",
            portName = "Berck Plage - Fort Mahon",
            latitude = 50.34167,
            longitude = 1.51583
        ),
        PortsMaree(
            portIndex = 23,
            portId = "BOUEE_FROMENTINE",
            portName = "Bouée Fromentine",
            latitude = 46.88469,
            longitude = -2.19317
        ),
        PortsMaree(
            portIndex = 24,
            portId = "BOUEE_LE_GOELAND",
            portName = "Bouée Le Goéland",
            latitude = 47.0,
            longitude = -2.1
        ),
        PortsMaree(
            portIndex = 25,
            portId = "BOULOGNE-SUR-MER",
            portName = "Boulogne-sur-Mer",
            latitude = 50.72744,
            longitude = 1.57769
        ),
        PortsMaree(
            portIndex = 26,
            portId = "BREHAT_MEN_JOLIGUET",
            portName = "Île de Bréhat",
            latitude = 48.83517,
            longitude = -3.00333
        ),
        PortsMaree(
            portIndex = 27,
            portId = "BREHEC",
            portName = "Brehec",
            latitude = 48.7265,
            longitude = -2.94583
        ),
        PortsMaree(
            portIndex = 28,
            portId = "BREST",
            portName = "Brest",
            latitude = 48.3825,
            longitude = -4.49472
        ),
        PortsMaree(
            portIndex = 29,
            portId = "BREST_MOULIN-BLANC",
            portName = "Moulin Blanc",
            latitude = 48.395,
            longitude = -4.43
        ),
        PortsMaree(
            portIndex = 30,
            portId = "BRIGNOGAN",
            portName = "Brignogan-Plage",
            latitude = 48.6785,
            longitude = -4.3175
        ),
        PortsMaree(
            portIndex = 31,
            portId = "CALAIS",
            portName = "Calais",
            latitude = 50.96933,
            longitude = 1.8675
        ),
        PortsMaree(
            portIndex = 33,
            portId = "CAMARET-SUR-MER",
            portName = "Camaret-sur-Mer",
            latitude = 48.27833,
            longitude = -4.59
        ),
        PortsMaree(
            portIndex = 34,
            portId = "CANCALE",
            portName = "Cancale",
            latitude = 48.68,
            longitude = -1.82667
        ),
        PortsMaree(
            portIndex = 35,
            portId = "CAPBRETON",
            portName = "Capbreton",
            latitude = 43.65367,
            longitude = -1.43717
        ),
        PortsMaree(
            portIndex = 36,
            portId = "CAP_FERRET",
            portName = "Cap Ferret",
            latitude = 44.62917,
            longitude = -1.24167
        ),
        PortsMaree(
            portIndex = 37,
            portId = "CARTERET",
            portName = "Carteret",
            latitude = 49.37283,
            longitude = -1.787
        ),
        PortsMaree(
            portIndex = 38,
            portId = "CAYEUX-SUR-MER",
            portName = "Cayeux-sur-Mer",
            latitude = 50.18333,
            longitude = 1.48333
        ),
        PortsMaree(
            portIndex = 40,
            portId = "CHERBOURG",
            portName = "Cherbourg",
            latitude = 49.65117,
            longitude = -1.6355
        ),
        PortsMaree(
            portIndex = 42,
            portId = "CONCARNEAU",
            portName = "Concarneau",
            latitude = 47.87333,
            longitude = -3.90667
        ),
        PortsMaree(
            portIndex = 43,
            portId = "CORDOUAN",
            portName = "Cordouan",
            latitude = 45.58333,
            longitude = -1.16667
        ),
        PortsMaree(
            portIndex = 44,
            portId = "COURSEULLES_LARGE",
            portName = "Courseulles-sur-Mer (Large)",
            latitude = 49.4,
            longitude = -0.46667
        ),
        PortsMaree(
            portIndex = 45,
            portId = "DAHOUET",
            portName = "Dahouet",
            latitude = 48.57917,
            longitude = -2.56933
        ),
        PortsMaree(
            portIndex = 46,
            portId = "DEAUVILLE",
            portName = "Trouville-Deauville",
            latitude = 49.36667,
            longitude = 0.08333
        ),
        PortsMaree(
            portIndex = 47,
            portId = "DIELETTE",
            portName = "Diélette",
            latitude = 49.55444,
            longitude = -1.86389
        ),
        PortsMaree(
            portIndex = 48,
            portId = "DIEPPE",
            portName = "Dieppe",
            latitude = 49.93,
            longitude = 1.085
        ),
        PortsMaree(
            portIndex = 49,
            portId = "DIVES-SUR-MER",
            portName = "Dives-sur-Mer",
            latitude = 49.3,
            longitude = -0.1
        ),
        PortsMaree(
            portIndex = 50,
            portId = "DOUARNENEZ",
            portName = "Douarnenez",
            latitude = 48.1,
            longitude = -4.31667
        ),
        PortsMaree(
            portIndex = 51,
            portId = "DUNKERQUE",
            portName = "Dunkerque",
            latitude = 51.05,
            longitude = 2.36667
        ),
        PortsMaree(
            portIndex = 52,
            portId = "DUNKERQUE_OUEST",
            portName = "Dunkerque Ouest",
            latitude = 51.0225,
            longitude = 2.18083
        ),
        PortsMaree(
            portIndex = 53,
            portId = "ENTREE_BAIE_DE_SOMME",
            portName = "Bouée entrée Baie de Somme (AT-SO)",
            latitude = 50.23522,
            longitude = 1.47231
        ),
        PortsMaree(
            portIndex = 54,
            portId = "ENTREE_RIVIERE_ETEL",
            portName = "Entrée rivière d'Étel",
            latitude = 47.64417,
            longitude = -3.21167
        ),
        PortsMaree(
            portIndex = 55,
            portId = "ERQUY_PORT",
            portName = "Erquy",
            latitude = 48.63922,
            longitude = -2.49019
        ),
        PortsMaree(
            portIndex = 56,
            portId = "ETEL",
            portName = "Port d'Étel",
            latitude = 47.65667,
            longitude = -3.20667
        ),
        PortsMaree(
            portIndex = 57,
            portId = "ETRETAT",
            portName = "Étretat",
            latitude = 49.71333,
            longitude = 0.19833
        ),
        PortsMaree(
            portIndex = 58,
            portId = "FECAMP",
            portName = "Fécamp",
            latitude = 49.76236,
            longitude = 0.36706
        ),
        PortsMaree(
            portIndex = 59,
            portId = "FORT-BOYARD",
            portName = "Fort Boyard",
            latitude = 46.0,
            longitude = -1.21167
        ),
        PortsMaree(
            portIndex = 60,
            portId = "FORT-ESPAGNOL",
            portName = "Fort Espagnol",
            latitude = 47.61233,
            longitude = -2.95317
        ),
        PortsMaree(
            portIndex = 62,
            portId = "FROMENTINE_EMBARCADERE",
            portName = "Fromentine (embarcadère)",
            latitude = 46.89333,
            longitude = -2.14
        ),
        PortsMaree(
            portIndex = 63,
            portId = "GLENAN_PENFRET",
            portName = "Penfret (Îles de Glénan)",
            latitude = 47.72217,
            longitude = -3.955
        ),
        PortsMaree(
            portIndex = 64,
            portId = "GOURY",
            portName = "Goury",
            latitude = 49.71417,
            longitude = -1.94867
        ),
        PortsMaree(
            portIndex = 65,
            portId = "GRANDCAMP",
            portName = "Grandcamp (Entrée chenal de Carentan)",
            latitude = 49.42017,
            longitude = -1.08661
        ),
        PortsMaree(
            portIndex = 66,
            portId = "GRANVILLE_LE_COCALEU",
            portName = "Granville",
            latitude = 48.83417,
            longitude = -1.64433
        ),
        PortsMaree(
            portIndex = 67,
            portId = "GRAVELINES",
            portName = "Gravelines",
            latitude = 51.01667,
            longitude = 2.1
        ),
        PortsMaree(
            portIndex = 69,
            portId = "HENDAYE",
            portName = "Hendaye",
            latitude = 43.37933,
            longitude = -1.78467
        ),
        PortsMaree(
            portIndex = 70,
            portId = "HERQUEVILLE",
            portName = "Herqueville",
            latitude = 49.65833,
            longitude = -1.88917
        ),
        PortsMaree(
            portIndex = 71,
            portId = "HOEDIC",
            portName = "Hoëdic",
            latitude = 47.3445,
            longitude = -2.87417
        ),
        PortsMaree(
            portIndex = 72,
            portId = "HONFLEUR",
            portName = "PK 355,850 : Honfleur",
            latitude = 49.41667,
            longitude = 0.23333
        ),
        PortsMaree(
            portIndex = 73,
            portId = "HOUAT",
            portName = "Houat",
            latitude = 47.404,
            longitude = -2.94967
        ),
        PortsMaree(
            portIndex = 74,
            portId = "ILES_CHAUSEY",
            portName = "Grande-Île (Îles Chausey)",
            latitude = 48.86667,
            longitude = -1.81667
        ),
        PortsMaree(
            portIndex = 75,
            portId = "ILES_SAINT-MARCOUF",
            portName = "Îles Saint-Marcouf",
            latitude = 49.5,
            longitude = -1.13333
        ),
        PortsMaree(
            portIndex = 76,
            portId = "ILE_AUX_MOINES_ER_GORED",
            portName = "Île aux Moines",
            latitude = 47.585,
            longitude = -2.85783
        ),
        PortsMaree(
            portIndex = 77,
            portId = "ILE_DE_SEIN_NORD",
            portName = "Île de Sein",
            latitude = 48.04017,
            longitude = -4.8475
        ),
        PortsMaree(
            portIndex = 78,
            portId = "ILE_D_AIX",
            portName = "Île d'Aix",
            latitude = 46.00833,
            longitude = -1.17333
        ),
        PortsMaree(
            portIndex = 80,
            portId = "LACANAU_LARGE",
            portName = "Lacanau",
            latitude = 45.03872,
            longitude = -1.56894
        ),
        PortsMaree(
            portIndex = 81,
            portId = "LANILDUT",
            portName = "L'Aber Ildut",
            latitude = 48.47117,
            longitude = -4.7545
        ),
        PortsMaree(
            portIndex = 82,
            portId = "LARMOR-BADEN",
            portName = "Larmor-Baden",
            latitude = 47.58167,
            longitude = -2.895
        ),
        PortsMaree(
            portIndex = 83,
            portId = "LA_COTINIERE",
            portName = "La Cotinière",
            latitude = 45.91417,
            longitude = -1.32583
        ),
        PortsMaree(
            portIndex = 85,
            portId = "LA_ROCHELLE-PALLICE",
            portName = "La Rochelle - La Pallice",
            latitude = 46.16,
            longitude = -1.22167
        ),
        PortsMaree(
            portIndex = 86,
            portId = "LA_TRINITE-SUR-MER",
            portName = "La Trinité-sur-Mer",
            latitude = 47.5875,
            longitude = -3.02556
        ),
        PortsMaree(
            portIndex = 87,
            portId = "LESCONIL",
            portName = "Lesconil",
            latitude = 47.79517,
            longitude = -4.21133
        ),
        PortsMaree(
            portIndex = 88,
            portId = "LES_ARDENTES",
            portName = "Les Ardentes",
            latitude = 48.96483,
            longitude = -1.8605
        ),
        PortsMaree(
            portIndex = 89,
            portId = "LES_HEAUX-DE-BREHAT",
            portName = "Les Héaux-de-Bréhat",
            latitude = 48.90814,
            longitude = -3.08333
        ),
        PortsMaree(
            portIndex = 90,
            portId = "LES_OITELLIERES",
            portName = "Île des Hébihens",
            latitude = 48.61667,
            longitude = -2.21
        ),
        PortsMaree(
            portIndex = 91,
            portId = "LES_SABLES-D_OLONNE",
            portName = "Les Sables d'Olonne",
            latitude = 46.4975,
            longitude = -1.79361
        ),
        PortsMaree(
            portIndex = 92,
            portId = "LEZARDRIEUX_PORT",
            portName = "Lézardrieux",
            latitude = 48.78333,
            longitude = -3.1
        ),
        PortsMaree(
            portIndex = 93,
            portId = "LE_CONQUET",
            portName = "Le Conquet",
            latitude = 48.35953,
            longitude = -4.78283
        ),
        PortsMaree(
            portIndex = 94,
            portId = "LE_CROISIC",
            portName = "Le Croisic",
            latitude = 47.3,
            longitude = -2.51667
        ),
        PortsMaree(
            portIndex = 95,
            portId = "LE_CROUESTY",
            portName = "Port du Crouesty",
            latitude = 47.54261,
            longitude = -2.89494
        ),
        PortsMaree(
            portIndex = 96,
            portId = "LE_DELLEC",
            portName = "Le Dellec",
            latitude = 48.35367,
            longitude = -4.562
        ),
        PortsMaree(
            portIndex = 97,
            portId = "LE_GRAND_CHARPENTIER",
            portName = "Le Grand Charpentier",
            latitude = 47.215,
            longitude = -2.31694
        ),
        PortsMaree(
            portIndex = 98,
            portId = "LE_GUILVINEC",
            portName = "Le Guilvinec",
            latitude = 47.79417,
            longitude = -4.2785
        ),
        PortsMaree(
            portIndex = 99,
            portId = "LE_HAVRE",
            portName = "Le Havre",
            latitude = 49.48167,
            longitude = 0.10617
        ),
        PortsMaree(
            portIndex = 100,
            portId = "LE_LEGUE_BOUEE",
            portName = "Le Légué (Bouée)",
            latitude = 48.56667,
            longitude = -2.68333
        ),
        PortsMaree(
            portIndex = 101,
            portId = "LE_LOGEO",
            portName = "Le Logeo",
            latitude = 47.54783,
            longitude = -2.8455
        ),
        PortsMaree(
            portIndex = 102,
            portId = "LE_PALAIS",
            portName = "Le Palais (Belle-Île)",
            latitude = 47.34767,
            longitude = -3.15217
        ),
        PortsMaree(
            portIndex = 103,
            portId = "LE_POULDU",
            portName = "Le Pouldu",
            latitude = 47.762,
            longitude = -3.54267
        ),
        PortsMaree(
            portIndex = 104,
            portId = "LE_POULIGUEN",
            portName = "Le Pouliguen",
            latitude = 47.25167,
            longitude = -2.40333
        ),
        PortsMaree(
            portIndex = 105,
            portId = "LE_SENEQUET",
            portName = "Le Sénéquet",
            latitude = 49.099,
            longitude = -1.68517
        ),
        PortsMaree(
            portIndex = 106,
            portId = "LE_TOUQUET",
            portName = "Le Touquet-Étaples",
            latitude = 50.51531,
            longitude = 1.561
        ),
        PortsMaree(
            portIndex = 107,
            portId = "LE_TREPORT",
            portName = "Le Tréport",
            latitude = 50.06667,
            longitude = 1.36667
        ),
        PortsMaree(
            portIndex = 108,
            portId = "LOCMARIAQUER",
            portName = "Locmariaquer",
            latitude = 47.57,
            longitude = -2.93
        ),
        PortsMaree(
            portIndex = 109,
            portId = "LOCQUEMEAU",
            portName = "Locquemeau",
            latitude = 48.725,
            longitude = -3.58167
        ),
        PortsMaree(
            portIndex = 110,
            portId = "LOCQUIREC",
            portName = "Locquirec",
            latitude = 48.7,
            longitude = -3.63333
        ),
        PortsMaree(
            portIndex = 111,
            portId = "LOCTUDY",
            portName = "Loctudy",
            latitude = 47.83333,
            longitude = -4.16667
        ),
        PortsMaree(
            portIndex = 112,
            portId = "L_HERBAUDIERE",
            portName = "L'Herbaudière (Île de Noirmoutier)",
            latitude = 47.02667,
            longitude = -2.29833
        ),
        PortsMaree(
            portIndex = 114,
            portId = "MIMIZAN",
            portName = "Mimizan",
            latitude = 44.21667,
            longitude = -1.3
        ),
        PortsMaree(
            portIndex = 115,
            portId = "MOLENE_NORD",
            portName = "Île Molène",
            latitude = 48.4035,
            longitude = -4.95467
        ),
        PortsMaree(
            portIndex = 116,
            portId = "MORGAT",
            portName = "Morgat",
            latitude = 48.2245,
            longitude = -4.49733
        ),
        PortsMaree(
            portIndex = 117,
            portId = "MORLAIX_PEN_AL_LANN",
            portName = "Château du Taureau",
            latitude = 48.68333,
            longitude = -3.88333
        ),
        PortsMaree(
            portIndex = 119,
            portId = "OMONVILLE-LA-ROGUE",
            portName = "Omonville-la-Rogue",
            latitude = 49.71383,
            longitude = -1.83467
        ),
        PortsMaree(
            portIndex = 120,
            portId = "OUESSANT_LAMPAUL",
            portName = "Baie de Lampaul (Île d'Ouessant)",
            latitude = 48.45,
            longitude = -5.1
        ),
        PortsMaree(
            portIndex = 121,
            portId = "OUISTREHAM",
            portName = "Ouistreham",
            latitude = 49.28333,
            longitude = -0.25
        ),
        PortsMaree(
            portIndex = 122,
            portId = "PAIMPOL",
            portName = "Paimpol",
            latitude = 48.79033,
            longitude = -2.95533
        ),
        PortsMaree(
            portIndex = 123,
            portId = "PASSAGE_SAINT-ARMEL",
            portName = "Saint-Armel (Le Passage)",
            latitude = 47.59133,
            longitude = -2.715
        ),
        PortsMaree(
            portIndex = 124,
            portId = "PENERF",
            portName = "Pénerf",
            latitude = 47.51433,
            longitude = -2.62383
        ),
        PortsMaree(
            portIndex = 125,
            portId = "PERROS-GUIREC_TRESTRAOU",
            portName = "Perros-Guirec",
            latitude = 48.82,
            longitude = -3.45833
        ),
        PortsMaree(
            portIndex = 126,
            portId = "PLOGOFF",
            portName = "Plogoff",
            latitude = 48.024,
            longitude = -4.69867
        ),
        PortsMaree(
            portIndex = 127,
            portId = "PLOGOFF_PORT-DU-VORLEN",
            portName = "Port du Vorlen",
            latitude = 48.053,
            longitude = -4.7125
        ),
        PortsMaree(
            portIndex = 128,
            portId = "PLOUMANACH",
            portName = "Ploumanac'h",
            latitude = 48.83667,
            longitude = -3.486
        ),
        PortsMaree(
            portIndex = 129,
            portId = "POINTE-AIGUILLON",
            portName = "Pointe de l'Aiguillon",
            latitude = 46.2575,
            longitude = -1.19083
        ),
        PortsMaree(
            portIndex = 130,
            portId = "POINTE_DE_GATSEAU",
            portName = "Pointe de Gatseau",
            latitude = 45.79917,
            longitude = -1.23667
        ),
        PortsMaree(
            portIndex = 131,
            portId = "POINTE_DE_SAINT-GILDAS",
            portName = "Pointe de Saint-Gildas",
            latitude = 47.14,
            longitude = -2.24667
        ),
        PortsMaree(
            portIndex = 132,
            portId = "POINTE_D_AGON",
            portName = "Pointe d'Agon",
            latitude = 48.9885,
            longitude = -1.62183
        ),
        PortsMaree(
            portIndex = 133,
            portId = "PONT_SEUDRE",
            portName = "Pont aval de la Seudre",
            latitude = 45.79956,
            longitude = -1.13781
        ),
        PortsMaree(
            portIndex = 134,
            portId = "PORNIC",
            portName = "Pornic",
            latitude = 47.10917,
            longitude = -2.11367
        ),
        PortsMaree(
            portIndex = 135,
            portId = "PORNICHET",
            portName = "Pornichet",
            latitude = 47.25833,
            longitude = -2.34667
        ),
        PortsMaree(
            portIndex = 136,
            portId = "PORT-BENI",
            portName = "Port-Béni",
            latitude = 48.84717,
            longitude = -3.17233
        ),
        PortsMaree(
            portIndex = 137,
            portId = "PORT-BLOC",
            portName = "Pointe de Grave",
            latitude = 45.56867,
            longitude = -1.06667
        ),
        PortsMaree(
            portIndex = 138,
            portId = "PORT-EN-BESSIN",
            portName = "Port-en-Bessin",
            latitude = 49.35139,
            longitude = -0.75556
        ),
        PortsMaree(
            portIndex = 139,
            portId = "PORT-HALIGUEN",
            portName = "Port-Haliguen",
            latitude = 47.48333,
            longitude = -3.1
        ),
        PortsMaree(
            portIndex = 140,
            portId = "PORT-JOINVILLE",
            portName = "Port-Joinville (Île d'Yeu)",
            latitude = 46.72667,
            longitude = -2.348
        ),
        PortsMaree(
            portIndex = 141,
            portId = "PORT-LOUIS_LOCMALO",
            portName = "Port-Louis (Locmalo)",
            latitude = 47.7055,
            longitude = -3.34533
        ),
        PortsMaree(
            portIndex = 142,
            portId = "PORT-MARIA",
            portName = "Port-Maria",
            latitude = 47.48333,
            longitude = -3.13331
        ),
        PortsMaree(
            portIndex = 143,
            portId = "PORT-NAVALO",
            portName = "Port-Navalo",
            latitude = 47.55,
            longitude = -2.91667
        ),
        PortsMaree(
            portIndex = 144,
            portId = "PORT-TUDY",
            portName = "Port-Tudy",
            latitude = 47.64458,
            longitude = -3.44631
        ),
        PortsMaree(
            portIndex = 146,
            portId = "PORTBAIL",
            portName = "Portbail",
            latitude = 49.30683,
            longitude = -1.74467
        ),
        PortsMaree(
            portIndex = 147,
            portId = "PORTIVY",
            portName = "Portivy",
            latitude = 47.53133,
            longitude = -3.14733
        ),
        PortsMaree(
            portIndex = 148,
            portId = "PORTSALL",
            portName = "Portsall",
            latitude = 48.56667,
            longitude = -4.71667
        ),
        PortsMaree(
            portIndex = 150,
            portId = "PORT_COMMERCE_LORIENT",
            portName = "Lorient (Port de commerce)",
            latitude = 47.7375,
            longitude = -3.3545
        ),
        PortsMaree(
            portIndex = 153,
            portId = "PORT_LA_FORET",
            portName = "Port-la-Forêt",
            latitude = 47.901,
            longitude = -3.97383
        ),
        PortsMaree(
            portIndex = 155,
            portId = "PORT_MANECH",
            portName = "Port Manec'h",
            latitude = 47.80083,
            longitude = -3.7385
        ),
        PortsMaree(
            portIndex = 156,
            portId = "PRIMEL",
            portName = "Anse de Primel",
            latitude = 48.71667,
            longitude = -3.83333
        ),
        PortsMaree(
            portIndex = 157,
            portId = "PTE_DE_GRAVE_LE_VERDON",
            portName = "Le Verdon-sur-Mer",
            latitude = 45.54633,
            longitude = -1.04083
        ),
        PortsMaree(
            portIndex = 158,
            portId = "RICHARD",
            portName = "Richard",
            latitude = 45.45367,
            longitude = -0.92306
        ),
        PortsMaree(
            portIndex = 159,
            portId = "ROCHES_DOUVRES",
            portName = "Les Roches Douvres",
            latitude = 49.10417,
            longitude = -2.81333
        ),
        PortsMaree(
            portIndex = 160,
            portId = "ROSCOFF",
            portName = "Roscoff",
            latitude = 48.71869,
            longitude = -3.96569
        ),
        PortsMaree(
            portIndex = 161,
            portId = "ROYAN",
            portName = "Royan",
            latitude = 45.61933,
            longitude = -1.028
        ),
        PortsMaree(
            portIndex = 162,
            portId = "RUYTINGEN_SW",
            portName = "Ruytingen",
            latitude = 51.09917,
            longitude = 1.78033
        ),
        PortsMaree(
            portIndex = 163,
            portId = "SAINT-CAST",
            portName = "Saint-Cast",
            latitude = 48.63833,
            longitude = -2.24333
        ),
        PortsMaree(
            portIndex = 164,
            portId = "SAINT-DENIS_D_OLERON",
            portName = "Saint-Denis d'Oléron",
            latitude = 46.03683,
            longitude = -1.37233
        ),
        PortsMaree(
            portIndex = 165,
            portId = "SAINT-GERMAIN-SUR-AY",
            portName = "Saint-Germain-sur-Ay",
            latitude = 49.2,
            longitude = -1.66667
        ),
        PortsMaree(
            portIndex = 166,
            portId = "SAINT-GUENOLE",
            portName = "Saint-Guénolé",
            latitude = 47.814,
            longitude = -4.3825
        ),
        PortsMaree(
            portIndex = 167,
            portId = "SAINT-MALO",
            portName = "Saint-Malo",
            latitude = 48.64117,
            longitude = -2.0275
        ),
        PortsMaree(
            portIndex = 168,
            portId = "SAINT-MARTIN_DE_RE",
            portName = "Saint-Martin-de-Ré (Île de Ré)",
            latitude = 46.208,
            longitude = -1.3655
        ),
        PortsMaree(
            portIndex = 169,
            portId = "SAINT-NAZAIRE",
            portName = "Saint-Nazaire",
            latitude = 47.26694,
            longitude = -2.20167
        ),
        PortsMaree(
            portIndex = 170,
            portId = "SAINT-QUAY-PORTRIEUX",
            portName = "Saint-Quay-Portrieux",
            latitude = 48.6475,
            longitude = -2.81806
        ),
        PortsMaree(
            portIndex = 171,
            portId = "SAINT-VAAST-LA-HOUGUE",
            portName = "Saint-Vaast-la-Hougue",
            latitude = 49.58767,
            longitude = -1.26433
        ),
        PortsMaree(
            portIndex = 172,
            portId = "SAINT-VALERY-EN-CAUX",
            portName = "Saint-Valery-en-Caux",
            latitude = 49.88333,
            longitude = 0.72
        ),
        PortsMaree(
            portIndex = 173,
            portId = "SAINTE_EVETTE",
            portName = "Sainte Evette",
            latitude = 48.00567,
            longitude = -4.55417
        ),
        PortsMaree(
            portIndex = 174,
            portId = "SAINT_BRIAC_SUR_MER",
            portName = "Saint-Briac-sur-Mer",
            latitude = 48.634,
            longitude = -2.1685
        ),
        PortsMaree(
            portIndex = 175,
            portId = "SANDETTIE_EST",
            portName = "Banc du Sandettié",
            latitude = 51.25,
            longitude = 2.05
        ),
        PortsMaree(
            portIndex = 177,
            portId = "SOCOA",
            portName = "Saint-Jean-de-Luz",
            latitude = 43.395,
            longitude = -1.68167
        ),
        PortsMaree(
            portIndex = 179,
            portId = "ST-GILLES-CROIX-DE-VIE",
            portName = "Saint-Gilles-Croix-de-Vie",
            latitude = 46.69667,
            longitude = -1.9425
        ),
        PortsMaree(
            portIndex = 180,
            portId = "TINDUFF",
            portName = "Tinduff",
            latitude = 48.33583,
            longitude = -4.3675
        ),
        PortsMaree(
            portIndex = 182,
            portId = "TREBEURDEN",
            portName = "Trébeurden",
            latitude = 48.77083,
            longitude = -3.58667
        ),
        PortsMaree(
            portIndex = 183,
            portId = "TREGUIER",
            portName = "Tréguier",
            latitude = 48.78633,
            longitude = -3.21933
        ),
        PortsMaree(
            portIndex = 184,
            portId = "TREHIGUIER",
            portName = "Tréhiguier",
            latitude = 47.495,
            longitude = -2.44
        ),
        PortsMaree(
            portIndex = 185,
            portId = "TREZ-HIR",
            portName = "Trez-Hir",
            latitude = 48.33967,
            longitude = -4.69933
        ),
        PortsMaree(
            portIndex = 186,
            portId = "VANNES",
            portName = "Vannes",
            latitude = 47.63833,
            longitude = -2.76083
        ),
        PortsMaree(
            portIndex = 187,
            portId = "VERGOYER_EST",
            portName = "Banc du Vergoyer",
            latitude = 50.59417,
            longitude = 1.33033
        ),
        PortsMaree(
            portIndex = 188,
            portId = "VIEUX-BOUCAU",
            portName = "Vieux-Boucau",
            latitude = 43.78333,
            longitude = -1.41667
        ),
        PortsMaree(
            portIndex = 189,
            portId = "WISSANT",
            portName = "Wissant",
            latitude = 50.88333,
            longitude = 1.66667
        )

        )
}
