/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package calendrier.maree.presentation.components

import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Brush
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.painter.BrushPainter
import androidx.compose.ui.text.font.FontStyle
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.sp
import androidx.wear.compose.material.ChipColors
import androidx.wear.compose.material.MaterialTheme
import androidx.wear.compose.material.Text
import androidx.wear.compose.material.TitleCard
import com.google.android.horologist.compose.material.CompactChip


/**
 * Simple Chip for displaying the Watch models.
 */
@Composable
fun WatchAppChip(
    watchModelNumber: Int,
    watchName: String,
    onClickWatch: (Int) -> Unit,
    modifier: Modifier = Modifier,
    colors: ChipColors
) {
    CompactChip(
        modifier = modifier,
//        icon = {
//            Icon(
//                imageVector = Icons.Default.Anchor,
//                contentDescription = "search",
//                modifier = Modifier
//            )
//        },
        label = watchName,
        colors = colors, //ChipDefaults.chipColors(backgroundColor = MaterialTheme.colors.primaryVariant, contentColor = Color.White),

        onClick = {
            onClickWatch(watchModelNumber)
        }
    )

}


/**
 * Simple Chip for displaying the Watch models.
 */
@Composable
fun WatchAppCards(
    watchModelNumber: Int,
    watchDateName: String,
    tabMaree : String,
    onClickWatch: (Int) -> Unit,
    modifier: Modifier = Modifier
) {

    var backgroundColors = listOf(MaterialTheme.colors.primaryVariant, MaterialTheme.colors.primaryVariant)
    if (watchModelNumber != 0) backgroundColors = listOf(MaterialTheme.colors.secondaryVariant, MaterialTheme.colors.secondaryVariant)
    TitleCard(
        onClick =  { onClickWatch(watchModelNumber) },
        title = { Text(textAlign = TextAlign.Center,color= Color.White, text = watchDateName) },
        backgroundPainter = BrushPainter(Brush.linearGradient(backgroundColors)),
        contentColor = Color(0xFFFFFFFF),//MaterialTheme.colors.secondary,
        titleColor = Color(0xFFFFFFFF),

        content = {
            Text(
                modifier = Modifier,
                fontSize = 12.sp,
                textAlign = TextAlign.Left,
                fontStyle = FontStyle.Italic,
                text = tabMaree
            )
        },
        time = {
            Text("")
        },
    )
}



