package calendrier.maree.presentation.util

import java.text.SimpleDateFormat
import java.util.Calendar
import java.util.Date
// fonction de traitement de date et heure

fun getDtNow() : Calendar
{
    val cal: Calendar = Calendar.getInstance()
    val trialTime = Date()
    cal.time = trialTime
    return  cal
}
fun getCurrentDt():String{
    return formatDateSt(getDtNow())
}

fun formatDateSt(vDate: Calendar): String {
    return jourSemaineCourt(vDate) + (vDate.get(Calendar.DATE)).toString() + textMoisLight(
        vDate) + " " + vDate.get(Calendar.YEAR).toString()
}

fun formatDateMaree(vDate : String) : String{
    val vCal= Calendar.getInstance()
    val formatter = SimpleDateFormat("yyyy-MM-dd")

    vCal.time = formatter.parse(vDate)!!

    return jourSemaineCourt(vCal) + (vCal.get(Calendar.DATE)).toString()+ textMoisLight(vCal)
}

fun jourSemaineCourt(vDate: Calendar): String {
// Set with all the words for the Game
    val allWeekDays =mapOf(
        1 to "Dim.",
        2 to "Lun.",
        3 to "Mar.",
        4 to "Mer.",
        5 to "Jeu.",
        6 to "Ven.",
        7 to "Sam."
    )

    val vRet :String = allWeekDays[vDate.get(Calendar.DAY_OF_WEEK)].toString() +" "
    return vRet
}

fun textMoisLight(vDate: Calendar): String {
// Set with all the words for the Game
    val allMoisName =mapOf(
        1 to "Jan",
        2 to "Fév",
        3 to "Mars",
        4 to "Avr",
        5 to "Mai",
        6 to "Juin",
        7 to "Juil",
        8 to "Aout",
        9 to "Sept",
        10 to "Oct",
        11 to "Nov",
        12 to "Déc"
    )
    val vRet :String = " " + allMoisName[(vDate.get(Calendar.MONTH))+1].toString()
    return vRet
}

fun textMois(vDate: Calendar): String {
// Set with all the words for the Game
    val allMoisName =mapOf(
        1 to "Janvier",
        2 to "Février",
        3 to "Mars",
        4 to "Avril",
        5 to "Mai",
        6 to "Juin",
        7 to "Juillet",
        8 to "Aout",
        9 to "Septembre",
        10 to "Octobre",
        11 to "Novembre",
        12 to "Décembre"
    )
    val vRet :String = " " + allMoisName[(vDate.get(Calendar.MONTH))+1].toString()
    return vRet
}