package calendrier.maree.presentation.util

import android.annotation.SuppressLint
import android.content.Context
import android.location.Location
import com.google.android.gms.location.FusedLocationProviderClient
import com.google.android.gms.location.LocationServices

lateinit var fusedLocationClient: FusedLocationProviderClient

@SuppressLint("MissingPermission") // On suppose que la permission a été accordée
fun getUserLocation(context: Context, callback: (latitude: Double, longitude: Double) -> Unit) {
    fusedLocationClient = LocationServices.getFusedLocationProviderClient(context)

    fusedLocationClient.lastLocation
        .addOnSuccessListener { location: Location? ->
            location?.let {
                callback(it.latitude, it.longitude)
            }
        }
}
