package com.mybus17000.data

import android.content.Context
import android.graphics.Color
import com.google.android.gms.maps.model.LatLng
import com.google.android.gms.maps.model.PolylineOptions

suspend fun loadAllBusRoutes(
    context: Context,
    routePolylineDataList: List<RoutePolylineData>,
    stops: List<StopFields>
): Map<String, RoutePolylineBus> {

    val routeMap = mutableMapOf<String, RoutePolylineBus>()

    routePolylineDataList.forEach { routeData ->
        try {
            // 1️⃣ Crée la polyline à partir des points
            val polylineOptions = PolylineOptions()
                .addAll(routeData.points)
                .color(Color.parseColor(routeData.color))
                .width(8f)

            // 2️⃣ Trouve les arrêts les plus proches du tracé
            // (petite optimisation : si tu stockes déjà les arrêts de chaque ligne, remplace cette partie)
            val nearbyStops = stops.filter { stop ->
                routeData.points.any { point ->
                    val dist = distanceBetween(
                        point.latitude,
                        point.longitude,
                        stop.stop_lat.toDouble(),
                        stop.stop_lon.toDouble()
                    )
                    dist < 200 // mètre : à ajuster selon précision
                }
            }.map { it.stop_id }

            // 3️⃣ Construit l’objet RoutePolylineBus
            val routeBus = RoutePolylineBus(
                stops = nearbyStops,
                polyline = polylineOptions,
                routeId = routeData.lineName
            )

            routeMap[routeData.lineName] = routeBus
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }

    return routeMap
}
